# GNU Lesser General Public License v3.0+ (see COPYING or https://www.gnu.org/licenses/lgpl-3.0.txt)
# (c) 2019, Christof Schulze <christof.schulze@fau.de>
#
# This file is part of Ammsml
#
# Ammsml is free software: you can redistribute it and/or modify it
# under the terms of the GNU Lesser General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# Ammsml is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Lesser General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public License
# along with Ammsml.  If not, see <http://www.gnu.org/licenses/>.

from ammsml.utils.parsing import to_text
from ammsml.utils.parsing_yaml import AMMSMLBaseYAMLObject


class AMMSMLError(Exception):
    """
    This is the base class for all errors raised from Ammsml code,
    and can be instantiated with two optional parameters beyond the
    error message to control whether detailed information is displayed
    when the error occurred while parsing a data file of some kind.

    Usage:
        raise AMMSMLError('some message here', obj=obj, show_content=True)

    Where "obj" is some subclass of ammsml.utils.parsing.yaml.objects.AMMSMLBaseYAMLObject,
    which should be returned by the DataLoader() class.

    Something like this, TODO to be improved
    """

    def __init__(self, message="", obj=None, show_content=True, suppress_extended_error=False, orig_exc=None):
        super(AMMSMLError, self).__init__(message)

        self._obj = obj
        self._show_content = show_content

        if obj and isinstance(obj, AMMSMLBaseYAMLObject):
            extended_error = self._get_extended_error()
            if extended_error and not suppress_extended_error:
                self.message = '%s\n\n%s' % (to_text(message), to_text(extended_error))
            else:
                self.message = '%s' % to_text(message)
        else:
            self.message = '%s' % to_text(message)


class AMMSMLParserError(AMMSMLError):

    pass


class TemplateParsingError(AMMSMLError):
    """a templating failure"""
    pass


class AMMSMLOptionsError(AMMSMLError):

    pass
