# GNU Lesser General Public License v3.0+ (see COPYING or https://www.gnu.org/licenses/lgpl-3.0.txt)
# (c) 2019, Christof Schulze <christof.schulze@fau.de>
#
# This file is part of Ammsml
#
# Ammsml is free software: you can redistribute it and/or modify it
# under the terms of the GNU Lesser General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# Ammsml is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Lesser General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public License
# along with Ammsml.  If not, see <http://www.gnu.org/licenses/>.

import yaml

# from ammsml.utils.parsing import to_text


class AMMSMLBaseYAMLObject(object):
    """
    the base class used to sub-class python built-in objects
    so that we can add attributes to them during yaml parsing
    """
    _data_source = None
    _line_number = 0
    _column_number = 0

    def _get_ammsml_position(self):
        return self._data_source, self._line_number, self._column_number

    def _set_ammsml_position(self, obj):
        try:
            (src, line, col) = obj
        except (TypeError, ValueError):
            raise AssertionError(
                'ammsml_pos can only be set with a tuple/list '
                'of three values: source, line number, column number'
            )
        self._data_source = src
        self._line_number = line
        self._column_number = col

    ammsml_pos = property(_get_ammsml_position, _set_ammsml_position)


class AMMSMLMapping(AMMSMLBaseYAMLObject, dict):
    """ sub class for dictionaries """
    pass


class AMMSMLUnicode(AMMSMLBaseYAMLObject, str):
    """ sub class for unicode objects """
    pass


class AMMSMLSequence(AMMSMLBaseYAMLObject, list):
    """ sub class for lists """
    pass
