import yaml

from utils.parsing import to_text


class AMMSMLBaseYAMLObject(object):
    """
    the base class used to sub-class python built-in objects
    so that we can add attributes to them during yaml parsing
    """
    _data_source = None
    _line_number = 0
    _column_number = 0

    def _get_ammsml_position(self):
        return self._data_source, self._line_number, self._column_number

    def _set_ammsml_position(self, obj):
        try:
            (src, line, col) = obj
        except (TypeError, ValueError):
            raise AssertionError(
                'ammsml_pos can only be set with a tuple/list '
                'of three values: source, line number, column number'
            )
        self._data_source = src
        self._line_number = line
        self._column_number = col

    ammsml_pos = property(_get_ammsml_position, _set_ammsml_position)


class AMMSMLMapping(AMMSMLBaseYAMLObject, dict):
    """ sub class for dictionaries """
    pass


class AMMSMLUnicode(AMMSMLBaseYAMLObject, str):
    """ sub class for unicode objects """
    pass


class AMMSMLSequence(AMMSMLBaseYAMLObject, list):
    """ sub class for lists """
    pass
