# GNU Lesser General Public License v3.0+ (see COPYING or https://www.gnu.org/licenses/lgpl-3.0.txt)
# (c) 2019, Christof Schulze <christof.schulze@fau.de>
#
# This file is part of Ammsml
#
# Ammsml is free software: you can redistribute it and/or modify it
# under the terms of the GNU Lesser General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# Ammsml is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Lesser General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public License
# along with Ammsml.  If not, see <http://www.gnu.org/licenses/>.

import yaml

# from ammsml.vars.hostvars import HostVars, HostVarsVars
from ammsml.utils.parsing.yaml.objects import AMMSMLUnicode, AMMSMLSequence, AMMSMLMapping


class AmmsmlDumper(yaml.SafeDumper):
    """
    A simple stub class that allows us to add representers
    for our overridden object types.
    """
    pass


def represent_hostvars(self, data):
    return self.represent_dict(dict(data))


represent_unicode = yaml.representer.SafeRepresenter.represent_str
represent_binary = yaml.representer.SafeRepresenter.represent_binary

AmmsmlDumper.add_representer(
    AMMSMLUnicode,
    represent_unicode,
)

# TODO add more representers