import unittest
from ammsml.utils.path import split_path


class SimpleSplitTest(unittest.TestCase):
    def test_single(self):
        test_list1 = ['/tmp/test']
        for i in test_list1:
            self.assertEqual(split_path(i), ['/', 'tmp', 'test'])

    def test_single_end(self):
        test_list2 = ['/tmp/test/']
        for i in test_list2:
            self.assertEqual(split_path(i), ['/', 'tmp', 'test'])

    def test_single_end(self):
        test_list3 = ['/tmp/test', 'raw', 'test2', 'test3/test31', 'test3/test32/test321']
        self.assertEqual(split_path(test_list3[0]), ['/', 'tmp', 'test'])
        self.assertEqual(split_path(test_list3[1]), ['raw'])
        self.assertEqual(split_path(test_list3[2]), ['test2'])
        self.assertEqual(split_path(test_list3[3]), ['test3', 'test31'])
        self.assertEqual(split_path(test_list3[4]), ['test3', 'test32', 'test321'])


if __name__ == '__main__':
    unittest.main()
