'''
this script is processing the data from the hierarchical interface results
the values for nx, ny were obtained as the L value as given in all_curves.ipynb 
'''

import csv
import collections
import numpy as np

def sort_lil(lil : list[list]) -> list[list]:
    for sublist in lil:
        sublist.sort()
    lil.sort()
    return lil

def read_edge_list(edge_list_path : str) -> list[list]:
    edge_list = []
    with open(edge_list_path, "r") as file:
        for row in file:
            edge_str = row.split(" ")
            edge = [int(node) for node in edge_str]
            edge_list.append(edge)
    return edge_list

def get_posititons(node : int, nx : int, ny : int) -> list[int,int,int] :
    return get_xposition(node, nx), get_yposition(node, nx, ny), get_zposition(node, nx, ny)
def get_xposition(node : int, nx : int) -> int:
    return (node%nx)
def get_yposition(node : int, nx : int, ny : int) -> int:
    return ((node//nx)%ny)
def get_zposition(node : int, nx : int, ny : int) -> int:
    return (node// (nx*ny))
    
def get_node_property_dictionary(edge_list : list[list], nx : int, ny : int) -> dict:
    node_list = []
    for edge in edge_list:
        node_list.extend(edge)
    node_list = set(node_list)
    node_property_dict = {}
    for node in node_list:
        x,y,z = get_posititons(node, nx, ny) 
        node_property_dict[node] = {"xposition" : x, "yposition" : y, "zposition" : z}
    return node_property_dict


if __name__ == "__main__":

    edge_list = read_edge_list("data/edgelist_0_seed1000_0")
    sorted_edge_list = sort_lil(edge_list)
    print(np.sqrt(sorted_edge_list[0][1]))
    nx = 128
    ny = nx
    node_property_dict = get_node_property_dictionary(edge_list, nx, ny)

