import os
import shutil
import subprocess 
from pathlib import Path

def get_git_hash():
    current_path = os.path.dirname(os.path.abspath(__file__))
    try:
        git_version = subprocess.check_output(['git', 'rev-parse', '--short', 'HEAD'], cwd=current_path).decode('ascii')
        git_version = git_version.rstrip("\n")
        return git_version
    except:
        return "not a git repository"
        
def write_metadata():
    git_hash = get_git_hash()
    file_path = "git_hash.txt"
    with open(file_path, "w") as file:
        file.write(git_hash)

def push_data_to(destination):
    current_path = Path(os.getcwd())
    destination_dir = Path(destination)
    if not destination_dir.exists():
        os.makedirs(destination)
    for file in current_path.glob("*.h5"):
        shutil.move(file.name, f'{destination_dir}/{file.name}')
    write_metadata()
    hash_file_name = "git_hash.txt"
    shutil.move(hash_file_name, f'{destination_dir}/{hash_file_name}')

def push_ivcat(destination):
    current_path = Path(os.getcwd())
    destination_dir = Path(destination)
    if not destination_dir.exists():
        raise AssertionError(f"dir {destination} not found")
    ivcat_filename = "ivcat.txt"
    cpp_script_filename = "fs_strength"
    shutil.move(ivcat_filename, f'{destination_dir}/{ivcat_filename}')
    shutil.copy(cpp_script_filename, f'{destination_dir}/{cpp_script_filename}')

def copy_runfile_to(runfile_name, destination, ):
    current_path = Path(os.getcwd())
    destination_dir = Path(destination)
    if not destination_dir.exists():
        raise AssertionError(f"dir {destination} not found")
    shutil.copy(runfile_name, destination_dir)