import sys
import numpy as np
import mechnet as mn
import os
sys.path.append(os.path.abspath("."))
print(sys.path)
from lib.push_data import push_data_to


def get_parametercollection(seed):
    par = mn.ParameterCollection()
    nx = 8 # needs to == el**h
    ny = nx
    nz = 6 # need to be >=  h +2 + o_set (+2 bc bound cond)    
    n = nx*ny*nz
    par.set_N(n)
    par.set_Nx(nx)
    par.set_Ny(ny)
    par.set_Nz(nz)
    par.set_NxNy()
    #new parameters necessary for the structure
    par.set_xhierarchicalelementsize(2) # log_el(nx) = h <-> nx = el**h 
    par.set_yhierarchicalelementsize(2)
    par.set_gapzoffset(1) # == o_set
    par.set_thresholdrng(seed)
    par.set_structurerng(seed + 1_000_000)
    par.set_weibullparameter(1.5)
    par.set_scalingfactor(1.00)
    par.set_uniformupperdirichlet(1.0)
    return par

def run_a_simulation_fuse(seed):
    constructor = mn.cubic3D.Cubic3DFullConnectionConstructor()
    #new decorators to modify network structure:
    #random positioning of missing edges fitting to the amount that would be missing in a hierarchical network with
    #element sizes as determined by set_xhierarchicalelementsize() and set_yhierarchicalelementsize()
    #in the corresponding directions; arangement dependent on seed given by set_structurerng()
    #for the random positioning
    constructor = mn.cubic3D.ShuffledHierarchicalOffsetDecorator(constructor)
    constructor = mn.cubic3D.ScalingWeibullThresholdDecorator(constructor)

    boundaries = mn.general.EmptyBoundariesConstructor()
    boundaries = mn.cubic3D.FixedLowerBoundaryDecorator(boundaries)
    boundaries = mn.cubic3D.UniformDisplacedUpperBoundaryDecorator(boundaries)
    
    parametercollection = get_parametercollection(seed)
    network = constructor.start_construction(parametercollection)
    bounded_network = boundaries.start_assign_boundaries(network)

    #switch to fuse simulation to make it easier to read the resulting stiffness matrix
    dict_of_simulation_parameters = {"niter":10_000_000, "externalV":1.0, "accuracy":12}
    builder = mn.sim.FuseDirichletBuilder()
    solver = mn.sim.PARDISOBindingsSolver()
    intrescal = mn.sim.StartInterimResultsCalculator() #InterimResultsCalculator stack pre-computes data needed for output and simulation step
    intrescal = mn.sim.FuseCurrentsVoltagesCalculator(intrescal)
    outgen = mn.sim.StartOutputGenerator()
    applier = mn.sim.HottestFuseBreakApplier()
    checker = mn.sim.NonInitialChecker(mn.sim.ConnectedPathChecker())
    simulation = mn.sim.Simulation(builder, solver, intrescal, outgen, applier, checker)
    
    dict_of_crs_edge_data = bounded_network.get_network_data() 
    simdata = simulation.start_simulation(dict_of_crs_edge_data, dict_of_simulation_parameters)
    
    simdata_dict = simdata.get_simdata_dict()
    network_descriptor_dict = bounded_network.get_construction_data()
    mn.datman.save_simulation_output(network_descriptor_dict, simdata_dict, simulation.simulationname, simulation.simulationdoc, suffix=str(seed), overwritemode = False)
    print("done with sim of seed", seed)
    return (network_descriptor_dict, simdata_dict, simulation.simulationname, simulation.simulationdoc)

if __name__=="__main__": 
    results = run_a_simulation_fuse(1000)
 #   push_data_to("/FASTTEMP/p7/lpyka/hierarchical_interface/dummy_test")
 #   for data in results:
 #       mn.datman.save_simulation_output(data[0], data[1], data[2], data[3], targetdirectory="./", suffix="", overwritemode=False)
    #print(data[1]["current_data"]["stiffnessmatrix"].toarray())
    print("\nRun successfull.")