#!/usr/bin/env python3
# -*- coding: utf-8 -*-
"""
This file is used to postprocess the data by Bapst et al. It relies on several
conventions used by Bapst to sample and format his data, so do not use this
to process other data without checking that it behaves as intended.
@author: Victor Bapst et al.
modified by Stefan Hiemer
"""

import pandas as pd
from glob import glob

if __name__=="__main__":

    for f in glob("*origin*"):
        origin = pd.read_csv(f,sep=',',header=None)
        origin.columns=["data source"]
        data = f.split("_")
        data = "_".join([data[0].split("-")[0],data[1]])
        data = pd.read_csv(data,sep=',',header=0)
        print(data)
        print(pd.concat((data,origin)))
